package com.esv.datacenter.cc.module.tenant.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 公司表
 * 
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-03-09 11:12:29
 */
@Data
@TableName("cc_tenant")
public class TenantEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 租户id
	 */
	@TableId
	private Long id;
	/**
	 * 租户名
	 */
	private String tenantName;
	/**
	 * 租户代码
	 */
	private String tenantCode;
	/**
	 * 联系人姓名
	 */
	private String contact;
	/**
	 * 联系人电话
	 */
	private String contactPhone;
	/**
	 * 状态  0:正常/1:锁定
	 */
	private Integer status;
	/**
	 * description 排序值
	 * author chenfm
	 * createTime 2020/4/1 17:48
	 **/
	private Integer orderNum;
	/**
	 * description 管理角色id
	 * author chenfm
	 * createTime 2020/4/1 17:48
	 **/
	private Long adminRoleId;
	/**
	 * 创建用户id
	 */
	private String createUser;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 更新用户id
	 */
	private String updateUser;
	/**
	 * 更新时间
	 */
	private Date updateTime;
	/**
	 * 已删除
	 */
	@TableLogic
	private Boolean deleted;

	@TableField(exist = false)
	private Boolean canEdited;

	public Boolean getCanEdited() {
		return id != 0;
	}

}
