package com.esv.datacenter.cc.module.apiauth.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.cc.module.apiauth.dao.ApiAuthorityDao;
import com.esv.datacenter.cc.module.apiauth.entity.ApiAuthorityEntity;
import com.esv.datacenter.cc.module.apiauth.service.ApiAuthorityService;
import com.esv.datacenter.cc.common.cache.CacheNames;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@CacheConfig(cacheNames = CacheNames.API_AUTHORITY)
@Service("apiAuthorityService")
public class ApiAuthorityServiceImpl extends ServiceImpl<ApiAuthorityDao, ApiAuthorityEntity> implements ApiAuthorityService {

    // 缓存中该数据10分钟过期
    @Cacheable(key = "'allApiMap'")
    @Override
    public Map<String, Object> getAllApiMap() {
        Map<String, Object> map = new HashMap<>();
        List<ApiAuthorityEntity> apiAuthorityEntityList = baseMapper.selectList(null);
        apiAuthorityEntityList.forEach(apiAuthorityEntity ->
                map.put(apiAuthorityEntity.getApi(), Integer.parseInt(apiAuthorityEntity.getAuthType()))
        );
        return map;
    }

    @CacheEvict(key = "'allApiMap'")
    @Override
    public void refreshApiMap() {
        log.info("清除api缓存成功");
    }

}