package com.esv.datacenter.cc.module.account.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.cc.module.account.dao.UserLoginInfoDao;
import com.esv.datacenter.cc.common.exception.RRException;
import com.esv.datacenter.cc.module.account.dto.UserLoginInfoDTO;
import com.esv.datacenter.cc.module.account.entity.UserLoginInfoEntity;
import com.esv.datacenter.cc.module.account.service.UserLoginInfoService;
import com.esv.datacenter.cc.module.user.dto.UserDTO;
import com.esv.datacenter.cc.module.user.service.UserService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service("userLoginInfoService")
public class UserLoginInfoServiceImpl extends ServiceImpl<UserLoginInfoDao, UserLoginInfoEntity> implements UserLoginInfoService {

    private UserService userService;

    @Autowired
    public UserLoginInfoServiceImpl(UserService userService) {
        this.userService = userService;
    }

    @Override
    public UserLoginInfoDTO getUserLoginInfo(Long tenantId, Long userId) {
        // 1.获取用户信息
        Map<String, Object> queryObj = new HashMap<>();
        queryObj.put("id", userId);
        UserDTO userEntity = userService.getUserDetailInfo(queryObj);
        if (null == userEntity) {
            throw new RRException("未查询到当前帐号的信息", 500);
        }

        // 2.获取当前登录信息
        UserLoginInfoEntity queryEntity = new UserLoginInfoEntity();
        queryEntity.setUserId(userId);
        Wrapper<UserLoginInfoEntity> queryWrapper = new QueryWrapper<>(queryEntity);
        UserLoginInfoEntity loginInfoEntity = baseMapper.selectOne(queryWrapper);
        if (null == loginInfoEntity) {
            throw new RRException("未查询到当前帐号的登录信息", 500);
        }

        // 3.获取上一次登录信息
        UserLoginInfoDTO userLoginInfoDTO = new UserLoginInfoDTO();
        userLoginInfoDTO.setUserId(userEntity.getId());
        userLoginInfoDTO.setAccount(userEntity.getAccount());
        userLoginInfoDTO.setRealName(userEntity.getRealName());
        userLoginInfoDTO.setEmail(userEntity.getEmail());
        userLoginInfoDTO.setMobile(userEntity.getMobile());
        userLoginInfoDTO.setDepartmentName(userEntity.getDepartmentName());
        userLoginInfoDTO.setRoleName(userEntity.getRoleName());
        userLoginInfoDTO.setStatus(loginInfoEntity.getStatus());
        userLoginInfoDTO.setLoginIp(loginInfoEntity.getIp());
        userLoginInfoDTO.setLoginTime(loginInfoEntity.getLoginTime().getTime());
        if (null != loginInfoEntity.getLogoutTime()) {
            userLoginInfoDTO.setLogoutTime(loginInfoEntity.getLogoutTime().getTime());
        }
        if (StringUtils.isNotBlank(loginInfoEntity.getLastIp())) {
            userLoginInfoDTO.setLastLoginIp(loginInfoEntity.getLastIp());
        }
        if (null != loginInfoEntity.getLastLoginTime()) {
            userLoginInfoDTO.setLastLoginTime(loginInfoEntity.getLastLoginTime().getTime());
        }
        return userLoginInfoDTO;
    }

    @Override
    public int saveLoginInfo(UserLoginInfoEntity loginInfoEntity) {
        UserLoginInfoEntity queryEntity = new UserLoginInfoEntity();
        queryEntity.setUserId(loginInfoEntity.getUserId());
        Wrapper<UserLoginInfoEntity> queryWrapper = new QueryWrapper<>(queryEntity);
        UserLoginInfoEntity dbEntity = baseMapper.selectOne(queryWrapper);
        if (null == dbEntity) {
            return baseMapper.insert(loginInfoEntity);
        } else {
            loginInfoEntity.setId(dbEntity.getId());
            // 修改时将登录信息保存为上次登录信息
            loginInfoEntity.setLastIp(dbEntity.getIp());
            loginInfoEntity.setLastLoginTime(dbEntity.getLoginTime());
            return baseMapper.updateById(loginInfoEntity);
        }
    }
}