package com.esv.datacenter.cc.common.handler;

import com.esv.common.response.EResponse;
import com.esv.datacenter.cc.common.constants.ApiResponseCode;
import com.esv.datacenter.cc.common.exception.RRException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import java.util.stream.Collectors;

/**
 * @description： Rest请求异常处理Handler
 * @author：hcbmailbox@163.com
 * @date：2020/1/8
 */
@Slf4j
@RestControllerAdvice
@ControllerAdvice
public class RestExceptionHandler {

    @ExceptionHandler(value = Exception.class)
    public EResponse defaultErrorHandler(HttpServletRequest req, Exception e) {
        EResponse eResponse;
        if (e instanceof RRException) {
            eResponse = EResponse.error().message(((RRException) e).getMsg());
        } else if (e instanceof MethodArgumentNotValidException) {
            String message = ((MethodArgumentNotValidException) e).getBindingResult().getAllErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining("|"));
            eResponse = EResponse.error(ApiResponseCode.PARAM_ERROR).message(message);
        } else if (e instanceof ConstraintViolationException) {
            String message = e.getMessage();
            if (message.contains(":")) {
                message = message.split(":")[1];
            }
            eResponse = EResponse.error(ApiResponseCode.PARAM_ERROR).message("参数错误：" + message);
        } else if (e instanceof MissingServletRequestParameterException) {
            eResponse = EResponse.error(ApiResponseCode.PARAM_ERROR);
        } else {
            eResponse = EResponse.error();
            log.error(e.getMessage(), e);
        }
        return eResponse;
    }

}
