package com.esv.datacenter.cc.module.role.controller;

import com.esv.datacenter.cc.module.role.entity.RoleMenuEntity;
import com.esv.datacenter.cc.module.role.form.RoleMenuForm;
import com.esv.datacenter.cc.module.role.service.RoleMenuService;
import com.esv.datacenter.cc.module.role.vo.RoleMenuVO;
import com.esv.common.response.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 角色与菜单对应关系
 *
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
@RestController
@RequestMapping("rolemenu")
public class RoleMenuController {

    private RoleMenuService roleMenuService;

    @Autowired
    public RoleMenuController(RoleMenuService roleMenuService) {
        this.roleMenuService = roleMenuService;
    }

    @GetMapping("list")
    public R list(@RequestParam("roleId") Long roleId) {
        RoleMenuVO roleMenuVO = roleMenuService.queryRoleMenuRowKey(roleId);
        return R.ok(roleMenuVO);
    }

    @PostMapping("setRoleMenu")
    public R setRoleMenu(@RequestBody @Validated RoleMenuForm roleMenuForm) {
        Long roleId = roleMenuForm.getRoleId();
        List<RoleMenuEntity> roleMenuEntityList = roleMenuForm.roleMenuEntityList();
        roleMenuService.saveRoleMenu(roleId, roleMenuEntityList);
        return R.ok();
    }

}
