package com.esv.datacenter.cc.module.role.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.esv.datacenter.cc.module.role.dto.RowKeyDTO;
import com.esv.datacenter.cc.module.role.entity.RoleMenuEntity;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 角色与菜单对应关系
 * 
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
@Mapper
public interface RoleMenuDao extends BaseMapper<RoleMenuEntity> {

    /**
     * description 权限角色和菜单编号查询角色菜单权限
     * param [roleId, menuCode]
     * return java.util.List<com.esv.cc.module.role.entity.RoleMenuEntity>
     * author chenfm
     * createTime 2020/4/4 15:57
     **/
    List<RoleMenuEntity> listByRoleIdAndMenuCode(Long roleId, String menuCode);

    /**
     * description 查询角色可用菜单的rowKey
     * param [roleId]
     * return java.util.List<java.lang.String>
     * author chenfm
     * createTime 2020/3/17 14:23
     **/
    List<RowKeyDTO> queryRoleMenuRowKey(Long roleId);

}
