package com.esv.datacenter.cc.module.index.service.impl;

import com.esv.datacenter.cc.module.index.service.IndexService;
import com.esv.datacenter.cc.module.menu.dto.MenuDTO;
import com.esv.datacenter.cc.module.menu.service.MenuService;
import com.esv.datacenter.cc.module.user.service.UserRoleService;
import com.esv.datacenter.cc.module.user.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description:
 * @project: cc
 * @name: IndexServiceImpl
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/3/5 17:11
 * @version:1.0
 */
@Service("indexServiceImpl")
public class IndexServiceImpl implements IndexService {

    private UserRoleService userRoleService;

    private UserService userService;

    private MenuService menuService;

    @Autowired
    public IndexServiceImpl(UserRoleService userRoleService, UserService userService,
                            MenuService menuService) {
        this.userRoleService = userRoleService;
        this.userService = userService;
        this.menuService = menuService;
    }

    @Override
    public List<MenuDTO> userSystemMenuTree(Long userId, Long systemId) {
        List<MenuDTO> menuDTOList;
        if (userRoleService.hasSuperAdminRole(userId)) {
            // 超级管理员查询所有菜单
            menuDTOList = menuService.listSystemMenu(systemId, null, null);
        } else {
            // 其他按角色权限查询
            menuDTOList = menuService.listSystemMenu(systemId, userId, null);
        }
        return menuDTOList;
    }

    @Override
    public List<String> menuCodeList(Long userId, Long systemId) {
        List<String> menuCodeList;
        if (userRoleService.hasSuperAdminRole(userId)) {
            // 超级管理员查询所有菜单
            menuCodeList = menuService.listMenuCode(systemId, null, null);
        } else {
            // 其他按角色权限查询
            menuCodeList = menuService.listMenuCode(systemId, userId, null);
        }
        return menuCodeList;
    }
}
