package com.esv.datacenter.cc.module.tenant.controller;

import com.esv.datacenter.cc.module.role.entity.RoleMenuEntity;
import com.esv.datacenter.cc.module.role.service.RoleMenuService;
import com.esv.datacenter.cc.module.role.vo.RoleMenuVO;
import com.esv.datacenter.cc.module.tenant.entity.TenantEntity;
import com.esv.datacenter.cc.module.tenant.form.TenantMenuForm;
import com.esv.datacenter.cc.module.tenant.service.TenantService;
import com.esv.common.response.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 公司可用系统表
 *
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-03-09 11:12:29
 */
@RestController
@RequestMapping("tenantMenu")
public class TenantMenuController {

    private TenantService tenantService;

    private RoleMenuService roleMenuService;

    @Autowired
    public TenantMenuController(TenantService tenantService,
                                RoleMenuService roleMenuService) {
        this.tenantService = tenantService;
        this.roleMenuService = roleMenuService;
    }

    /**
     * 列表
     */
    @GetMapping("/list")
    public R list(@RequestParam("tenantId") Long tenantId){
        TenantEntity tenantEntity = tenantService.getById(tenantId);
        if (tenantEntity == null) {
            return R.error("租户id有误");
        }
        Long roleId = tenantEntity.getAdminRoleId();
        RoleMenuVO roleMenuVO = roleMenuService.queryRoleMenuRowKey(roleId);
        return R.ok(roleMenuVO);
    }

    /**
     * 设置租户权限
     */
    @PostMapping("/setTenantMenu")
    public R setTenantMenu(@RequestBody TenantMenuForm tenantMenuForm){
        List<RoleMenuEntity> roleMenuEntityList = tenantMenuForm.roleMenuEntityList();
        TenantEntity tenantEntity = tenantService.getById(tenantMenuForm.getTenantId());
        if (tenantEntity == null) {
            return R.error("租户id有误");
        }
        Long roleId = tenantEntity.getAdminRoleId();
        roleMenuService.saveRoleMenu(roleId, roleMenuEntityList);
        return R.ok();
    }

}
