package com.esv.datacenter.cc.module.department.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 部门表
 *
 * @author chenfm
 * @email chenfengman@esvtek.com
 * @date 2020-01-09 11:32:08
 */
@Data
@TableName("cc_department")
public class DepartmentEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 部门id
	 */
	@TableId
	private Long id;
	/**
	 * 部门名
	 */
	private String departmentName;
	/**
	 * 上级部门id
	 */
	private Long parentId;
	/**
	 * 租户id
	 */
	private Long tenantId;
	/**
	 * 分类:1.集团/2.分公司/3.部门
	 */
	private String category;
	/**
	 * 负责人
	 */
	private String principal;
	/**
	 * 电话
	 */
	private String phone;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 排序
	 */
	private Integer orderNum;
	/**
	 * 创建用户
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createUser;
	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;
	/**
	 * 更新用户
	 */
	@TableField(fill = FieldFill.UPDATE)
	private String updateUser;
	/**
	 * 更新时间
	 */
	@TableField(fill = FieldFill.UPDATE)
	private Date updateTime;
	/**
	 * 已删除
	 */
	@TableLogic
	private Boolean deleted;

}
