package com.esv.datacenter.cc.module.authentication.service;

import com.esv.datacenter.cc.module.account.bo.TokenBO;
import com.esv.common.response.EResponse;
import com.esv.feign.cc.res.WebReqAuthRes;

/**
 * 权限验证服务，权限信息会进行缓缓，当相关内容变更时需要更新缓存
 */
public interface AuthenticationService {

    /**
     * description 开始鉴权
     * param [webReqAuthRes, menuCode, url]
     * return com.esv.common.response.EResponse<com.esv.feign.cc.res.WebReqAuthRes>
     * author chenfm
     * createTime 2020/4/4 13:57
     **/
    EResponse<WebReqAuthRes> access(WebReqAuthRes webReqAuthRes, String menuCode, String url);

    /**
     * description 设置Token校验时的数据权限
     * param [tokenBO, webReqAuthRes]
     * return void
     * author HuangChaobin
     * createTime 2020/06/17 11:30
     **/
    void setTokenDataPerm(TokenBO tokenBO, WebReqAuthRes webReqAuthRes);

    /**
     * 判断指定用户是否有权限访问url
     * @param userId 用户名
     * @param url url
     * @return 有权限访问返回true，没有权限返回false
     */
    boolean isAllowAccess(long userId, String url);

    /**
     * 用户删除、冻结时更新权限缓存
     * @param userId 用户Id
     */
    void updateCacheByUserId(long userId);

    /**
     * 角色信息删除、变更时更新权限缓存
     * @param roleId
     */
    void updateCacheByRoleId(long roleId);

    /**
     * 菜单信息变更、删除、锁定时更新权限缓存
     * @param menuId
     */
    void updateCacheByMenuId(long menuId);
}
