package com.esv.datacenter.base.module.city.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.base.common.em.DbDeletedEnum;
import com.esv.datacenter.base.module.city.dao.BaseCityCodeDao;
import com.esv.datacenter.base.module.city.entity.BaseCityCodeEntity;
import com.esv.datacenter.base.module.city.service.BaseCityCodeService;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service("baseCityCodeService")
public class BaseCityCodeServiceImpl extends ServiceImpl<BaseCityCodeDao, BaseCityCodeEntity> implements BaseCityCodeService {

    @Override
    @Cacheable(value = "htwl-base-service::geo::city", key="'allTree'")
    public List<JSONObject> getAllRegionTree() {
        // 查询全国行政区划列表
        List<BaseCityCodeEntity> cityCodeEntityList = this.baseMapper.selectList(new LambdaQueryWrapper<BaseCityCodeEntity>()
                .select(BaseCityCodeEntity::getCode, BaseCityCodeEntity::getBriefName, BaseCityCodeEntity::getParentCode, BaseCityCodeEntity::getLevel)
                .eq(BaseCityCodeEntity::getDeleted, DbDeletedEnum.NO.getCode())
                .orderByAsc(BaseCityCodeEntity::getCode));

        // 构造返回数据
        List<JSONObject> provinceList = new ArrayList<>();
        List<JSONObject> cityList = null;
        List<JSONObject> districtList = null;
        JSONObject province = null;
        JSONObject city = null;
        JSONObject district;
        BaseCityCodeEntity entity;
        String cityCode = null;
        int citySize = cityCodeEntityList.size();
        for (int i = 0; i < citySize; i++) {
            entity = cityCodeEntityList.get(i);
            if ("1".equals(entity.getLevel())) {
                if (null != province) {
                    city.put("districtList", districtList);
                    cityList.add(city);
                    province.put("cityList", cityList);
                    provinceList.add(province);
                    city = null;
                }
                province = new JSONObject();
                province.put("code", entity.getCode());
                province.put("name", entity.getBriefName());
                cityList = new ArrayList<>();
            } else if ("2".equals(entity.getLevel())) {
                if (null != city) {
                    city.put("districtList", districtList);
                    cityList.add(city);
                }
                city = new JSONObject();
                cityCode = entity.getCode();
                city.put("code", entity.getCode());
                city.put("name", entity.getBriefName());
                districtList = new ArrayList<>();
            } else {
                if (!cityCode.equals(entity.getParentCode())) {
                    city.put("districtList", districtList);
                    districtList = new ArrayList<>();
                }
                district = new JSONObject();
                district.put("code", entity.getCode());
                district.put("name", entity.getBriefName());
                districtList.add(district);
            }

            if (citySize == (i + 1)) {
                city.put("districtList", districtList);
                cityList.add(city);
                province.put("cityList", cityList);
                provinceList.add(province);
            }
        }

        return provinceList;
    }

    @Override
    @Cacheable(value = "htwl-base-service::geo::city", key="'allMap'")
    public Map<String, String> getAllRegionMap() {
        // 查询全国行政区划列表
        List<BaseCityCodeEntity> cityCodeEntityList = this.baseMapper.selectList(new LambdaQueryWrapper<BaseCityCodeEntity>()
                .select(BaseCityCodeEntity::getCode, BaseCityCodeEntity::getBriefName, BaseCityCodeEntity::getParentCode, BaseCityCodeEntity::getLevel)
                .eq(BaseCityCodeEntity::getDeleted, DbDeletedEnum.NO.getCode())
                .orderByAsc(BaseCityCodeEntity::getCode));

        // 遍历
        Map<String, String> data = new HashMap<>(cityCodeEntityList.size());
        cityCodeEntityList.forEach(baseCityCodeEntity -> {
            data.put(baseCityCodeEntity.getCode(), baseCityCodeEntity.getBriefName());
        });

        return data;
    }
}