package com.esv.datacenter.base.module.dict.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.base.module.dict.service.DicTypeService;
import com.esv.datacenter.base.module.dict.dao.DicDao;
import com.esv.datacenter.base.module.dict.entity.DicEntity;
import com.esv.datacenter.base.module.dict.form.DictForm;
import com.esv.datacenter.base.module.dict.service.DicService;
import com.esv.datacenter.base.module.dict.vo.DictVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


@Service("dicService")
public class DicServiceImpl extends ServiceImpl<DicDao, DicEntity> implements DicService {

    DicTypeService dicTypeService;

    @Autowired
    public DicServiceImpl(DicTypeService dicTypeService) {
        this.dicTypeService = dicTypeService;
    }

    @Override
    public List<JSONObject> getDictByTypes(String[] types) {
        List<JSONObject> dictList = new ArrayList<>();
        // 遍历获取数据
        String type;
        for (int i = 0; i < types.length; i++) {
            type = StringUtils.trim(types[i]);
            if (StringUtils.isEmpty(type)) {
                continue;
            }
            JSONObject jsonObject = new JSONObject();
            List<DictVO> dictVOList = new ArrayList<>();
            // 判断是否有效字典表类型
            if (this.isValidType(type)) {
                List<DicEntity> dicEntityList = dicTypeService.getDictByType(type);
                // 数据转换
                dicEntityList.forEach(dicEntity -> {
                    DictVO dictVO = new DictVO();
                    BeanUtils.copyProperties(dicEntity, dictVO);
                    dictVOList.add(dictVO);
                });
            }
            jsonObject.put("dictList", dictVOList);
            jsonObject.put("type", type);
            dictList.add(jsonObject);
        }

        return dictList;
    }

    @Override
    public boolean isValidType(String type) {
        List<String> validTypeList = dicTypeService.getAllValidType();
        if (StringUtils.isEmpty(type)) {
            return false;
        } else {
            return validTypeList.contains(type);
        }
    }

    @Override
    public DicEntity getName(DictForm form) {
        DicEntity queryEntity = new DicEntity();
        queryEntity.setType(form.getType());
        queryEntity.setCode(form.getCode());
        QueryWrapper<DicEntity> queryWrapper = new QueryWrapper<>(queryEntity);
        return this.baseMapper.selectOne(queryWrapper);
    }
}