package com.esv.superhive.base.module.dict.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.superhive.base.module.dict.form.DictForm;
import com.esv.superhive.base.module.dict.entity.DicEntity;

import java.util.List;

/**
 * 
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-11 09:56:26
 */
public interface DicService extends IService<DicEntity> {

    /**
     * description 获取指定type类型的字典表数据
     * param [types]
     * return java.util.List<com.alibaba.fastjson.JSONObject>
     * author Administrator
     * createTime 2020/04/11 10:22
     **/
    List<JSONObject> getDictByTypes(String[] types);

    /**
     * description 判断是否有效type类型
     * param [type]
     * return boolean
     * author Administrator
     * createTime 2020/04/11 11:04
     **/
    boolean isValidType(String type);

    /**
     * description 获取字典名称
     * param [form]
     * return com.esv.freight.base.module.dict.entity.DicEntity
     * author Administrator
     * createTime 2020/04/21 14:29
     **/
    DicEntity getName(DictForm form);

}

