package com.esv.superhive.base.module.dict.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.superhive.base.common.response.EResponse;
import com.esv.superhive.base.module.dict.service.DicTypeService;
import com.esv.superhive.base.module.dict.service.GoodsTypeService;
import com.esv.superhive.base.common.exception.EException;
import com.esv.superhive.base.common.validator.groups.ValidatorDetail;
import com.esv.superhive.base.module.dict.entity.DicEntity;
import com.esv.superhive.base.module.dict.form.DetailForm;
import com.esv.superhive.base.module.dict.form.DictForm;
import com.esv.superhive.base.module.dict.service.DicService;
import com.esv.superhive.base.module.dict.service.VehicleTypeService;
import com.esv.superhive.base.module.dict.vo.TreeVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @description: 字典表Controller
 * @project: base-service
 * @name: com.esv.htwl.base.module.dict.controller.DictionaryController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/11 9:59
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/dict")
public class DictionaryController {

    private DicService dicService;

    DicTypeService dicTypeService;

    private GoodsTypeService goodsTypeService;

    private VehicleTypeService vehicleTypeService;

    @Autowired
    public DictionaryController(DicService dicService, DicTypeService dicTypeService,
                                GoodsTypeService goodsTypeService, VehicleTypeService vehicleTypeService) {
        this.dicService = dicService;
        this.dicTypeService = dicTypeService;
        this.goodsTypeService = goodsTypeService;
        this.vehicleTypeService = vehicleTypeService;
    }

    /**
     * description 获取字典表
     * param [form]
     * return com.esv.freight.base.common.response.EResponse
     * author Administrator
     * createTime 2020/04/11 10:30
     **/
    @PostMapping("/get")
    public EResponse getDictByTypes(@RequestBody DictForm form) {
        String[] types;
        if (StringUtils.isBlank(form.getType())) {
            List<String> validTypeList = dicTypeService.getAllValidType();
            types = validTypeList.toArray(new String[validTypeList.size()]);
        } else {
            types = form.getType().split(",");
        }
        List<JSONObject> data = dicService.getDictByTypes(types);
        return EResponse.ok(data);
    }

    /**
     * description 获取字典名称
     * param [form]
     * return com.esv.freight.base.common.response.EResponse
     * author Administrator
     * createTime 2020/04/21 14:32
     **/
    @PostMapping("/getName")
    public EResponse getName(@RequestBody @Validated(ValidatorDetail.class) DictForm form) {
        DicEntity entity = dicService.getName(form);
        if (null == entity) {
            throw new EException(1001, "未找到对应的字典数据");
        }
        JSONObject data = new JSONObject();
        data.put("name", entity.getName());
        return EResponse.ok(data);
    }

    /**
     * description 获取货物类型基础数据
     * param []
     * return com.esv.freight.base.common.response.EResponse
     * author Administrator
     * createTime 2020/04/20 15:56
     **/
    @PostMapping("/getGoodsType")
    public EResponse getGoodsType() {
        List<TreeVO> data = goodsTypeService.getAllGoodsType();
        return EResponse.ok(data);
    }

    /**
     * description 获取货物名称
     * param [form]
     * return com.esv.freight.base.common.response.EResponse
     * author Administrator
     * createTime 2020/04/22 17:48
     **/
    @PostMapping("/getGoodsNameByCode")
    public EResponse getGoodsNameByCode(@RequestBody @Validated(ValidatorDetail.class) DetailForm form) {
        String name = goodsTypeService.getGoodsNameByCode(form.getCode());
        JSONObject data = new JSONObject();
        data.put("name", name);
        return EResponse.ok(data);
    }

    /**
     * description 获取车辆类型基础数据
     * param []
     * return com.esv.freight.base.common.response.EResponse
     * author Administrator
     * createTime 2020/04/20 16:38
     **/
    @PostMapping("/getVehicleType")
    public EResponse getVehicleType() {
        List<TreeVO> data = vehicleTypeService.getAllVehicleType();
        return EResponse.ok(data);
    }

    /**
     * description 获取车辆名称
     * param [form]
     * return com.esv.freight.base.common.response.EResponse
     * author Administrator
     * createTime 2020/04/22 17:49
     **/
    @PostMapping("/getVehicleNameByCode")
    public EResponse getVehicleNameByCode(@RequestBody @Validated(ValidatorDetail.class) DetailForm form) {
        String name = vehicleTypeService.getVehicleNameByCode(form.getCode());
        JSONObject data = new JSONObject();
        data.put("name", name);
        return EResponse.ok(data);
    }

}
