package com.esv.superhive.base.module.city.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;

import java.math.BigDecimal;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 全国行政区划表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-10 10:19:46
 */
@Data
@TableName("base_city_code")
public class BaseCityCodeEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 *
	 */
	@TableId
	private Long id;
	/**
	 * 行政区划代码
	 */
	private String code;
	/**
	 * 行政区划全称
	 */
	private String fullName;
	/**
	 * 行政区划简称
	 */
	private String briefName;
	/**
	 * 行政区划简称拼音
	 */
	private String briefNameSpell;
	/**
	 * 上级行政区划代码
	 */
	private String parentCode;
	/**
	 * 行政级别：1-省、2-市、3-区县
	 */
	private String level;
	/**
	 * 政府所在地经度
	 */
	private BigDecimal governmentLon;
	/**
	 * 政府所在地纬度
	 */
	private BigDecimal governmentLat;
	/**
	 * 行政区域中心点经度
	 */
	private BigDecimal regionLon;
	/**
	 * 行政区域中心点纬度
	 */
	private BigDecimal regionLat;
	/**
	 * 是否删除：0-未删除、1-已删除
	 */
	@TableLogic
	private Boolean deleted;
	/**
	 * 创建者
	 */
	private String createUser;
	/**
	 * 修改者
	 */
	private String updateUser;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 修改时间
	 */
	private Date updateTime;

}
