package com.esv.superhive.base.module.captcha.form;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @description: 图片验证码Form
 * @project: base-service
 * @name: com.esv.htwl.base.module.captcha.form.CaptchaForm
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/11 15:19
 * @version:1.0
 */
@Data
public class CaptchaForm {

    @Length(max = 64, message = "参数id长度不合法")
    @NotBlank(message = "参数id不能为空")
    private String id;

    @Length(max = 10, message = "参数captcha长度不合法")
    @NotBlank(message = "参数captcha不能为空")
    private String captcha;

}
