package com.esv.superhive.base.config;

import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @description:
 * @project: htwl-base-service
 * @name: com.esv.htwl.base.config.MybatisPlusConfig
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/09 9:58
 * @version:1.0
 */
@Configuration
@MapperScan({"com.esv.superhive.base.*.*.dao"})
public class MybatisPlusConfig {

    /**
     * 分页插件
     */
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }

    /**
     * description MybatisPlus乐观锁插件
     * param []
     * return com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor
     * author chenfm
     * createTime 2020/4/13 20:17
     **/
    @Bean
    public OptimisticLockerInterceptor optimisticLockerInterceptor() {
        return new OptimisticLockerInterceptor();
    }

}
