package com.esv.superhive.base.module.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.superhive.base.module.dict.service.GoodsTypeService;
import com.esv.superhive.base.common.exception.EException;
import com.esv.superhive.base.module.dict.dao.GoodsTypeDao;
import com.esv.superhive.base.module.dict.entity.GoodsTypeEntity;
import com.esv.superhive.base.module.dict.vo.DictVO;
import com.esv.superhive.base.module.dict.vo.TreeVO;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service("goodsTypeService")
public class GoodsTypeServiceImpl extends ServiceImpl<GoodsTypeDao, GoodsTypeEntity> implements GoodsTypeService {

    @Override
    @Cacheable(value = "goods-type", key="'allValid'")
    public List<TreeVO> getAllGoodsType() {
        // 查询
        QueryWrapper<GoodsTypeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper
                .select("code", "name", "parent_code")
                .orderByAsc("code");
        List<GoodsTypeEntity> typeEntityList = this.baseMapper.selectList(queryWrapper);

        // 数据转换
        List<TreeVO> dataList = new ArrayList<>();
        List<DictVO> children;
        TreeVO treeVO;
        DictVO dictVO;
        Map<Integer, Integer> map = new HashMap<>();
        for (int i = 0; i < typeEntityList.size(); i++) {
            GoodsTypeEntity typeEntity = typeEntityList.get(i);
            if (null == typeEntity.getParentCode()) {
                treeVO = new TreeVO();
                BeanUtils.copyProperties(typeEntity, treeVO);
                map.put(treeVO.getCode(), i);
                dataList.add(treeVO);
            } else {
                Integer pCode = typeEntity.getParentCode();
                if (map.containsKey(pCode)) {
                    Integer index = map.get(pCode);
                    treeVO = dataList.get(index);
                    children = treeVO.getChildren();
                    if (null == treeVO.getChildren()) {
                        children = new ArrayList<>();
                    }
                    dictVO = new DictVO();
                    BeanUtils.copyProperties(typeEntity, dictVO);
                    children.add(dictVO);
                    treeVO.setChildren(children);
                    dataList.set(index, treeVO);
                }
            }
        }

        return dataList;
    }

    @Override
    @Cacheable(value = "goods-type", key="#code")
    public String getGoodsNameByCode(Integer code) {
        GoodsTypeEntity entity = new GoodsTypeEntity();
        entity.setCode(code);
        QueryWrapper<GoodsTypeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(entity);

        GoodsTypeEntity goodsTypeEntity = this.getOne(queryWrapper);
        if (null == goodsTypeEntity) {
            throw new EException(1001, "无效的code");
        }

        return goodsTypeEntity.getName();
    }
}