package com.esv.superhive.base.module.captcha.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.esv.superhive.base.common.util.AESSecretUtils;
import com.esv.superhive.base.common.util.CaptchaUtils;
import com.esv.superhive.base.module.captcha.service.CaptchaService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @description:
 * @project: base-service
 * @name: com.esv.htwl.base.module.captcha.service.impl.CaptchaServiceImpl
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/11 14:16
 * @version:1.0
 */
@Service("CaptchaService")
@Slf4j
public class CaptchaServiceImpl implements CaptchaService {

    @Value("${aes.sha1prng.key:3.1415926535}")
    private String AES_KEY;

    @Override
    public JSONObject createCaptcha() throws IOException {
        // 获取图片验证码接口
        Object[] objs = CaptchaUtils.createCaptchaImage();
        String captchaCode = (String) objs[0];
        BufferedImage captchaImage = (BufferedImage) objs[1];

        // 创建图片验证码ID
        String captchaID = AESSecretUtils.encryptToStr("esv," + captchaCode + "," + System.currentTimeMillis(), AES_KEY);

        // base64编码图片
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write(captchaImage, "jpg", byteArrayOutputStream);
        byteArrayOutputStream.flush();
        String base64Img = this.replaceEnter(Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray()));

        // 返回数据
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", captchaID);
        jsonObject.put("captcha", "data:image/png;base64," + base64Img);

        return jsonObject;
    }

    @Override
    public Boolean verifyCaptcha(String captchaID, String captchaCode) {
        String captchaInfo;
        try {
            captchaInfo = AESSecretUtils.decryptToStr(captchaID, AES_KEY);
        } catch (Exception e) {
            log.error("AES解析图片ID信息失败");
            return false;
        }
        String[] captchaInfos = captchaInfo.split(",");
        if (3 != captchaInfos.length) {
            return false;
        }
        if (!"esv".equals(captchaInfos[0])) {
            return false;
        }
        String code4ID = captchaInfo.split(",")[1];
        if (captchaCode.equalsIgnoreCase(code4ID)) {
            return true;
        } else {
            return false;
        }
    }

    private String replaceEnter(String str) {
        String reg = "[\n-\r]";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(str);
        return m.replaceAll("");
    }
}
