package com.esv.superhive.base.module.captcha.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.superhive.base.common.response.EResponse;
import com.esv.superhive.base.module.captcha.form.CaptchaForm;
import com.esv.superhive.base.module.captcha.service.CaptchaService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;

/**
 * @description: 图片验证码Controller
 * @project: base-service
 * @name: com.esv.htwl.base.module.captcha.controller.CaptchaController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/11 13:57
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/captcha")
public class CaptchaController {

    private CaptchaService captchaService;

    @Autowired
    public CaptchaController(CaptchaService captchaService) {
        this.captchaService = captchaService;
    }

    /**
     * description 获取图片验证码
     * param []
     * return com.esv.freight.base.common.response.EResponse
     * author Administrator
     * createTime 2020/04/11 13:59
     **/
    @PostMapping("/get")
    public EResponse getDefaultCaptcha() {
        JSONObject data;
        try {
            data = captchaService.createCaptcha();
        } catch (IOException e) {
            log.error("创建图片验证码时发生错误");
            log.error(e.getMessage(), e);
            return EResponse.error();
        }
        return EResponse.ok(data);
    }

    /**
     * description 校验图片验证码
     * param [captchaForm]
     * return com.esv.freight.base.common.response.EResponse
     * author Administrator
     * createTime 2020/04/11 15:37
     **/
    @PostMapping("/verify")
    public EResponse verifyCaptcha(@RequestBody @Validated CaptchaForm captchaForm) {
        JSONObject data = new JSONObject();
        data.put("result", captchaService.verifyCaptcha(captchaForm.getId(), captchaForm.getCaptcha()));
        
        return EResponse.ok(data);
    }

}
