package com.esv.superhive.base.module.batch.form;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @description:
 * @project: freight-base-service
 * @name: com.esv.htwl.base.module.batch.form.BatchIdForm
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/4/13 20:34
 * @version: 1.0
 */
@Data
public class BatchIdForm {

    /**
     * 前缀
     **/
    @Pattern(regexp = "^[a-zA-Z]{1,5}$", message="前缀格式有误")
    @NotBlank(message = "前缀不能为空")
    private String prefix;
    /**
     * 日期格式
     **/
    @Pattern(regexp = "^[y]{2,4}[M]{2}[d]{2}$", message="日期格式有误")
    @NotBlank(message = "日期格式不能为空")
    private String formatter;
    /**
     * 长度
     **/
    @NotNull(message = "长度不能为空")
    private Integer length;

    private String dateStr;

}
