package com.esv.superhive.base.module.batch.controller;

import com.esv.superhive.base.common.response.ECode;
import com.esv.superhive.base.common.response.EResponse;
import com.esv.superhive.base.common.util.DateUtils;
import com.esv.superhive.base.module.batch.form.BatchIdForm;
import com.esv.superhive.base.module.batch.service.BatchIdService;
import com.esv.superhive.base.module.batch.vo.BatchIdVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description:
 * @project: freight-base-service
 * @name: com.esv.htwl.base.module.batch.controller.BatchIdController
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/4/13 20:34
 * @version: 1.0
 */
@Slf4j
@RestController
@RequestMapping("batchId")
public class BatchIdController {

    private BatchIdService batchIdService;

    @Autowired
    public BatchIdController(BatchIdService batchIdService) {
        this.batchIdService = batchIdService;
    }

    /**
     * description 获取批次号
     * param [batchIdForm]
     * return com.esv.freight.base.common.response.EResponse<com.esv.freight.base.module.batch.vo.BatchIdVO>
     * author Administrator
     * createTime 2020/05/18 9:42
     **/
    @PostMapping("generate")
    public EResponse<BatchIdVO> generate(@RequestBody @Validated BatchIdForm batchIdForm) {
        String formatter = batchIdForm.getFormatter();
        String dateStr = DateUtils.getSysdateStr(formatter);
        if (formatter.length() != dateStr.length()) {
            return EResponse.error(ECode.BATCHID_FORMATTOR_ERROR);
        }

        if ((batchIdForm.getLength() <= (dateStr.length() + batchIdForm.getPrefix().length()))
            || batchIdForm.getLength() > 30) {
            return EResponse.error(ECode.BATCHID_LENTGH_ERROR);
        }

        batchIdForm.setDateStr(dateStr);
        String result;
        // 失败重试一次
        try {
            result = batchIdService.generateBatchId(batchIdForm);
        } catch (Exception e) {
            result = batchIdService.generateBatchId(batchIdForm);
        }
        BatchIdVO batchIdVO = new BatchIdVO();
        batchIdVO.setBatchId(result);
        return EResponse.ok(batchIdVO);
    }

}
