package com.esv.datacenter.base;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.junit.After;
import org.junit.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

/**
 * @description:
 * @project: freight-base-service
 * @name: com.esv.htwl.base.BaseController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/15 14:09
 * @version:1.0
 */
@Slf4j
@Data
public class BaseTestController {

    @Autowired
    WebApplicationContext webApplicationContext;

    MockMvc mockMvc;

    private static Long TEST_START_TIME;
    private static Long TEST_END_TIME;

    @Before
    public void before() {
        log.info("=================================== Test Start ===================================");
        mockMvc = MockMvcBuilders.webAppContextSetup(webApplicationContext).build();
        TEST_START_TIME = System.currentTimeMillis();
    }

    @After
    public void after() {
        TEST_END_TIME = System.currentTimeMillis();
        log.info("Test耗时：" + (TEST_END_TIME - TEST_START_TIME) + "毫秒");
        log.info("=================================== Test End ===================================");
    }

}
