package com.esv.datacenter.base.module.city.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.datacenter.base.common.response.EResponse;
import com.esv.datacenter.base.module.city.service.BaseCityCodeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @description: 地理信息服务，城市服务
 * @project: base-service
 * @name: com.esv.htwl.base.module.city.controller.BaseCityController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/10 15:18
 * @version:1.0
 */
@Slf4j
@RestController
@RequestMapping("/geo/city")
public class BaseCityController {

    private BaseCityCodeService baseCityCodeService;

    @Autowired
    public BaseCityController(BaseCityCodeService baseCityCodeService) {
        this.baseCityCodeService = baseCityCodeService;
    }

    /**
     * description 获取全国省市行政区划(树形结构)
     * param []
     * return com.esv.freight.base.common.response.EResponse
     * author Administrator
     * createTime 2020/04/10 15:22
     **/
    @PostMapping("/getAllRegion")
    public EResponse getAllRegion() {
        List<JSONObject> data = baseCityCodeService.getAllRegionTree();
        return EResponse.ok(data);
    }

    /**
     * description 获取全国城市列表数据(键值对)
     * param []
     * return com.esv.freight.base.common.response.EResponse
     * author Administrator
     * createTime 2020/05/08 15:33
     **/
    @PostMapping("/getAllRegionMap")
    public EResponse getAllRegionMap() {
        return EResponse.ok(baseCityCodeService.getAllRegionMap());
    }
}
