package com.esv.datacenter.base.module.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.base.common.exception.EException;
import com.esv.datacenter.base.module.dict.dao.VehicleTypeDao;
import com.esv.datacenter.base.module.dict.entity.VehicleTypeEntity;
import com.esv.datacenter.base.module.dict.service.VehicleTypeService;
import com.esv.datacenter.base.module.dict.vo.DictVO;
import com.esv.datacenter.base.module.dict.vo.TreeVO;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service("vehicleTypeService")
public class VehicleTypeServiceImpl extends ServiceImpl<VehicleTypeDao, VehicleTypeEntity> implements VehicleTypeService {

    @Override
    @Cacheable(value = "vehicle-type", key="'allValid'")
    public List<TreeVO> getAllVehicleType() {
        // 查询
        QueryWrapper<VehicleTypeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper
                .select("code", "name", "parent_code")
                .orderByAsc("code");
        List<VehicleTypeEntity> typeEntityList = this.baseMapper.selectList(queryWrapper);

        // 数据转换
        List<TreeVO> dataList = new ArrayList<>();
        List<DictVO> children;
        TreeVO treeVO;
        DictVO dictVO;
        Map<Integer, Integer> map = new HashMap<>();
        for (int i = 0; i < typeEntityList.size(); i++) {
            VehicleTypeEntity typeEntity = typeEntityList.get(i);
            if (null == typeEntity.getParentCode()) {
                treeVO = new TreeVO();
                BeanUtils.copyProperties(typeEntity, treeVO);
                map.put(treeVO.getCode(), i);
                dataList.add(treeVO);
            } else {
                Integer pCode = typeEntity.getParentCode();
                if (map.containsKey(pCode)) {
                    Integer index = map.get(pCode);
                    treeVO = dataList.get(index);
                    children = treeVO.getChildren();
                    if (null == treeVO.getChildren()) {
                        children = new ArrayList<>();
                    }
                    dictVO = new DictVO();
                    BeanUtils.copyProperties(typeEntity, dictVO);
                    children.add(dictVO);
                    treeVO.setChildren(children);
                    dataList.set(index, treeVO);
                }
            }
        }

        return dataList;
    }

    @Override
    @Cacheable(value = "vehicle-type", key="#code")
    public String getVehicleNameByCode(Integer code) {
        VehicleTypeEntity entity = new VehicleTypeEntity();
        entity.setCode(code);
        QueryWrapper<VehicleTypeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(entity);

        VehicleTypeEntity vehicleTypeEntity = this.getOne(queryWrapper);
        if (null == vehicleTypeEntity) {
            throw new EException(1001, "无效的code");
        }

        return vehicleTypeEntity.getName();
    }
}