package com.esv.datacenter.base.module.batch.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.datacenter.base.module.batch.dao.BatchIdDao;
import com.esv.datacenter.base.module.batch.entity.BatchIdEntity;
import com.esv.datacenter.base.module.batch.form.BatchIdForm;
import com.esv.datacenter.base.module.batch.service.BatchIdService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @project: freight-base-service
 * @name: com.esv.htwl.base.module.batch.service.impl.BatchIdServiceImpl
 * @author: chenfm
 * @email: chenfengman@esvtek.com
 * @createTime: 2020/4/13 20:32
 * @version: 1.0
 */
@Service("batchIdService")
public class BatchIdServiceImpl extends ServiceImpl<BatchIdDao, BatchIdEntity> implements BatchIdService {

    @Override
    public String generateBatchId(BatchIdForm batchIdForm) {
        Integer counter;
        BatchIdEntity queryObj = new BatchIdEntity();
        queryObj.setPrefix(batchIdForm.getPrefix());
        queryObj.setFormatter(batchIdForm.getDateStr());
        BatchIdEntity record = this.baseMapper.selectMaxCounter(queryObj);
        if (null == record) {
            counter = 1;
        } else {
            counter = record.getCounter() + 1;
        }
        BatchIdEntity batchIdEntity = new BatchIdEntity();
        batchIdEntity.setPrefix(batchIdForm.getPrefix());
        batchIdEntity.setFormatter(batchIdForm.getDateStr());
        batchIdEntity.setCounter(counter);
        int length = batchIdForm.getLength() - batchIdForm.getPrefix().length() - batchIdForm.getFormatter().length();
        String result = StringUtils.leftPad(String.valueOf(counter), length, "0");
        result = batchIdForm.getPrefix() + batchIdForm.getDateStr() + result;
        batchIdEntity.setResult(result);
        this.baseMapper.insert(batchIdEntity);

        return result;
    }

}
