package com.esv.datacenter.base.module.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.esv.datacenter.base.module.dict.dao.DicDao;
import com.esv.datacenter.base.module.dict.entity.DicEntity;
import com.esv.datacenter.base.module.dict.service.DicTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @description:
 * @project: base-service
 * @name: com.esv.htwl.base.module.dict.service.impl.DicTypeServiceImpl
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/11 11:15
 * @version:1.0
 */
@Service("dicTypeService")
public class DicTypeServiceImpl implements DicTypeService {

    private DicDao dicDao;

    @Autowired
    public DicTypeServiceImpl(DicDao dicDao) {
        this.dicDao = dicDao;
    }

    @Override
    @Cacheable(value = "dict::type", key="#type")
    public List<DicEntity> getDictByType(String type) {
        QueryWrapper<DicEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("code", "name")
                .eq("type", type)
                .orderByAsc("order_num");

        return dicDao.selectList(queryWrapper);
    }

    @Override
    @Cacheable(value = "dict::type", key="'allValid'")
    public List<String> getAllValidType() {
        return dicDao.selectAllValidType();
    }
}
