package com.esv.datacenter.base.module.city.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.datacenter.base.module.city.entity.BaseCityCodeEntity;

import java.util.List;
import java.util.Map;

/**
 * 全国行政区划表
 *
 * @author 黄朝斌
 * @email huangchaobin@esvtek.com
 * @date 2020-04-10 09:30:08
 */
public interface BaseCityCodeService extends IService<BaseCityCodeEntity> {

    /**
     * description 获取全国城市列表数据(树形结构)
     * param []
     * return java.util.List<com.alibaba.fastjson.JSONObject>
     * author Administrator
     * createTime 2020/04/10 15:17
     **/
    List<JSONObject> getAllRegionTree();

    /**
     * description 获取全国城市列表数据(键值对)
     * param []
     * return com.alibaba.fastjson.JSONObject
     * author Administrator
     * createTime 2020/05/08 15:28
     **/
    Map<String, String> getAllRegionMap();

}

