package com.esv.freight.app.module.grabbing.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.util.FeignUtils;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import com.esv.freight.app.feign.TmsGrabInterface;
import com.esv.freight.app.feign.TmsOrderInterface;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.grabbing.form.OrderGrabbingForm;
import com.esv.freight.app.module.grabbing.form.OrderGrabbingQueryForm;
import com.esv.freight.app.module.grabbing.vo.GrabListItemVO;
import com.esv.freight.app.module.grabbing.vo.GrabListVO;
import com.mysql.cj.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @description: 司机找货抢单订单Controller
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.grabbing.controller.GrabController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 13:00
 * @version:1.0
 */
@RestController
@RequestMapping("/driverBackend/grab")
@Slf4j
@Validated
public class GrabController {

    private TmsGrabInterface tmsGrabInterface;

    @Autowired
    public GrabController(TmsGrabInterface tmsGrabInterface) {
        this.tmsGrabInterface = tmsGrabInterface;
    }

    /**
     * description 获取路线找货列表
     * param orderGrabbingQueryForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/24 17:00
     **/
    @PostMapping("/find/list")
    public EResponse getFindGoodsList(@RequestBody(required=false) @Validated(ValidatorList.class) OrderGrabbingQueryForm orderGrabbingQueryForm) {

        // 调用查询抢单信息列表接口
        JSONObject reqJson = new JSONObject();
        if(orderGrabbingQueryForm.getDriverId() != null) {
            reqJson.put("driverId", orderGrabbingQueryForm.getDriverId());
        }

        if(!StringUtils.isNullOrEmpty(orderGrabbingQueryForm.getDeliveryProvinceCode())) {
            reqJson.put("deliveryProvinceCode", orderGrabbingQueryForm.getDeliveryProvinceCode());
        }

        if(!StringUtils.isNullOrEmpty(orderGrabbingQueryForm.getDeliveryCityCode())) {
            reqJson.put("deliveryCityCode", orderGrabbingQueryForm.getDeliveryCityCode());
        }

        if(!StringUtils.isNullOrEmpty(orderGrabbingQueryForm.getReceiveProvinceCode())) {
            reqJson.put("receiveProvinceCode", orderGrabbingQueryForm.getReceiveProvinceCode());
        }

        if(!StringUtils.isNullOrEmpty(orderGrabbingQueryForm.getReceiveCityCode())) {
            reqJson.put("receiveCityCode", orderGrabbingQueryForm.getReceiveCityCode());
        }

        if(orderGrabbingQueryForm.getVehicleTypeMain() != null) {
            reqJson.put("vehicleTypeMain", orderGrabbingQueryForm.getVehicleTypeMain());
        }

        if(orderGrabbingQueryForm.getVehicleTypeSub() != null) {
            reqJson.put("vehicleTypeSub", orderGrabbingQueryForm.getVehicleTypeSub());
        }

        if(orderGrabbingQueryForm.getVehicleTypeList() != null) {
            reqJson.put("vehicleTypeList", orderGrabbingQueryForm.getVehicleTypeList());
        }

        if(orderGrabbingQueryForm.getGoodsTypeList() != null) {
            reqJson.put("goodsTypeList", orderGrabbingQueryForm.getGoodsTypeList());
        }

        if(orderGrabbingQueryForm.getVehicleLength() != null) {
            reqJson.put("vehicleLength", orderGrabbingQueryForm.getVehicleLength());
        }

        if(orderGrabbingQueryForm.getDeliveryStartTime() != null) {
            reqJson.put("deliveryStartTime", orderGrabbingQueryForm.getDeliveryStartTime());
        }

        if(orderGrabbingQueryForm.getDeliveryEndTime() != null) {
            reqJson.put("deliveryEndTime", orderGrabbingQueryForm.getDeliveryEndTime());
        }

        reqJson.put("pageNum", orderGrabbingQueryForm.getPageNum());
        reqJson.put("pageSize", orderGrabbingQueryForm.getPageSize());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsGrabInterface.getOrderGrabbingList(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        GrabListVO grabListVO = new GrabListVO();
        JSONObject data = result.getJSONObject("data");
        grabListVO.setPageSize(data.getLong("pageSize"));
        grabListVO.setPageNum(data.getLong("pageNum"));
        grabListVO.setTotal(data.getLong("totalSize"));
        grabListVO.setRecordSize(data.getLong("recordSize"));
        if(grabListVO.getRecordSize() > 0) {
            JSONArray items = data.getJSONArray("records");
            List<GrabListItemVO> records = new ArrayList<>();
            for(int i=0; i<items.size(); ++i) {
                GrabListItemVO vo = new GrabListItemVO();
                JSONObject object = items.getJSONObject(i);
                vo.setId(object.getLong("id"));
                vo.setOrderId(object.getLong("orderId"));
                vo.setOrderNo(object.getString("orderNo"));
                vo.setVehicleTypeMain(object.getInteger("vehicleTypeMain"));
                vo.setVehicleTypeSub(object.getInteger("vehicleTypeSub"));
                vo.setPublishGoodsAmount(object.getBigDecimal("publishGoodsAmount"));
                vo.setRequiredVehicleCount(object.getInteger("requiredVehicleCount"));
                vo.setCurrentVehicleCount(object.getInteger("currentVehicleCount"));
                vo.setCurrentGoodsAmount(object.getBigDecimal("currentGoodsAmount"));
                vo.setFreightUnitPriceOutput(object.getBigDecimal("freightUnitPriceOutput"));
                vo.setBargainAllowed(object.getBoolean("bargainAllowed"));
                vo.setContractSigned(object.getBoolean("contractSigned"));
                vo.setDeliveryProvinceCode(object.getString("deliveryProvinceCode"));
                vo.setDeliveryCityCode(object.getString("deliveryCityCode"));
                vo.setDeliveryDistrictCode(object.getString("deliveryDistrictCode"));
                vo.setDeliveryDetailAddress(object.getString("deliveryDetailAddress"));
                vo.setReceiveProvinceCode(object.getString("receiveProvinceCode"));
                vo.setReceiveCityCode(object.getString("receiveCityCode"));
                vo.setReceiveDistrictCode(object.getString("receiveDistrictCode"));
                vo.setReceiveDetailAddress(object.getString("receiveDetailAddress"));
                vo.setGoodsNameCode(object.getInteger("goodsNameCode"));
                vo.setGoodsName(object.getString("goodsName"));
                vo.setGoodsUnit(object.getInteger("goodsUnit"));
                vo.setDeliveryStrategy(object.getInteger("deliveryStrategy"));
                vo.setRequiredDeliveryTime(object.getLong("requiredDeliveryTime"));
                vo.setRequiredReceiveTime(object.getLong("requiredReceiveTime"));
                vo.setCreateTime(object.getLong("createTime"));
                vo.setBargainRange(object.getInteger("bargainRange"));
                records.add(vo);
            }

            grabListVO.setRecord(records);
        }
        return EResponse.ok(grabListVO);
    }

    /**
     * description 抢单
     * param orderGrabbingForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/24 17:00
     **/
    @PostMapping("/find/grab")
    public EResponse grabOrder(@RequestBody(required=false) @Validated(ValidatorInsert.class) OrderGrabbingForm orderGrabbingForm) {

        // 调用抢单接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("orderGrabbingId", orderGrabbingForm.getOrderGrabbingId());
        reqJson.put("driverId", orderGrabbingForm.getDriverId());
        reqJson.put("vehicleId", orderGrabbingForm.getVehicleId());
        reqJson.put("signId", orderGrabbingForm.getSignId());
        reqJson.put("bargainFreight", orderGrabbingForm.getBargainFreight());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsGrabInterface.grabOrder(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") == 1009) {
            return EResponse.error(1009, "已经抢过该订单了");
        }

        if(!FeignUtils.isFeignSuccess(result)) {
            return FeignUtils.getFeignEResponse(result);
        }

        return EResponse.ok();
    }

    /**
     * description 判断司机是否符合抢单条件
     * param orderGrabbingForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/06/05 09:20
     **/
    @PostMapping("/find/grab/prepare")
    public EResponse prepare(@RequestBody(required=false) @Validated(ValidatorInsert.class) OrderGrabbingForm orderGrabbingForm) {

        // 调用抢单接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("orderGrabbingId", orderGrabbingForm.getOrderGrabbingId());
        reqJson.put("driverId", orderGrabbingForm.getDriverId());
        reqJson.put("vehicleId", orderGrabbingForm.getVehicleId());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsGrabInterface.grabOrderPrepare(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") == 1009) {
            return EResponse.error(1009, "已经抢过该订单了");
        }

        if(!FeignUtils.isFeignSuccess(result)) {
            return FeignUtils.getFeignEResponse(result);
        }

        return EResponse.ok();
    }
}
