package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.feign.DriverVehicleInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/06 20:00
 * @version:1.0
 */
@FeignClient(value = "freight-customer-service")
public interface DriverVehicleInterface {

    /**
     * 获取司机的车辆列表
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "customer/carrier/driver/vehicle/listByDriver")
    JSONObject listByDriver(JSONObject bodyJson);
}
