package com.esv.freight.app.module.account.form;

import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @description: 货主实名认证验证类
 * @project: freight-app-service
 * @name: com.esv.freight.module.ownerBackend.account.form.OwnerAuthForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 10:00
 * @version:1.0
 */
@Data
public class OwnerAuthForm {

    /**
     * 货主ID
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class})
    private Long id;

    /**
     * 货主类型：1-个人、2-企业
     */
    @Pattern(regexp = "[12]", message = "参数ownerType不合法", groups = {ValidatorUpdate.class})
    @NotBlank(message = "参数ownerType不能为空", groups = {ValidatorUpdate.class})
    private String ownerType;

    /**
     * 身份证正面图片数据
     */
    @NotBlank(message = "参数idCardFileFront不能为空", groups = {ValidatorUpdate.class})
    private String idCardFileFrontUrl;

    /**
     * 身份证背面图片数据
     */
    @NotBlank(message = "参数idCardFileBack不能为空", groups = {ValidatorUpdate.class})
    private String idCardFileBackUrl;

    /**
     * 姓名
     */
    @Length(max = 20, message = "参数name长度不合法", groups = {ValidatorUpdate.class})
    @NotBlank(message = "参数name不能为空", groups = {ValidatorUpdate.class})
    private String name;

    /**
     * 身份证号码
     */
    @Length(min = 18, max = 18, message = "参数idCard长度不合法", groups = {ValidatorUpdate.class})
    @NotBlank(message = "参数idCard不能为空", groups = {ValidatorUpdate.class})
    private String idCard;

    /**
     * 	身份证有效期，格式yyyy.MM.dd，或长期
     */
    @Length(max = 50, message = "参数idCardExpireDate长度不合法", groups = {ValidatorUpdate.class})
    private String idCardExpireDate;

    /**
     * 	省份代码
     */
    @Length(min = 6, max = 6, message = "参数provinceCode长度不合法", groups = {ValidatorUpdate.class})
    @NotBlank(message = "参数provinceCode不能为空", groups = {ValidatorUpdate.class})
    private String provinceCode;

    /**
     * 	市代码
     */
    @Length(min = 6, max = 6, message = "参数cityCode长度不合法", groups = {ValidatorUpdate.class})
    @NotBlank(message = "参数cityCode不能为空", groups = {ValidatorUpdate.class})
    private String cityCode;

    /**
     *  区县代码
     */
    @Length(min = 6, max = 6, message = "参数districtCode长度不合法", groups = {ValidatorUpdate.class})
    @NotBlank(message = "参数districtCode不能为空", groups = {ValidatorUpdate.class})
    private String districtCode;

    /**
     * 	详细地址
     */
    @Length(max = 100, message = "参数detailAddress长度不合法", groups = {ValidatorUpdate.class})
    @NotBlank(message = "参数detailAddress不能为空", groups = {ValidatorUpdate.class})
    private String detailAddress;

    /**
     * 客户名称
     */
    @Length(max = 50, message = "参数ownerFullName长度不合法", groups = {ValidatorUpdate.class})
    private String ownerFullName;

    /**
     * 客户简称
     */
    @Length(max = 50, message = "参数ownerBriefName长度不合法", groups = {ValidatorUpdate.class})
    private String ownerBriefName;

    /**
     * 统一社会信用代码
     */
    @Length(max = 20, message = "参数uniCreditCode长度不合法", groups = {ValidatorUpdate.class})
    private String uniCreditCode;

    /**
     * 营业期限
     */
    @Length(max = 50, message = "参数creditExpireDate长度不合法", groups = {ValidatorUpdate.class})
    private String creditExpireDate;

    /**
     * 营业执照正本ULR
     */
    @Length(max = 200, message = "参数creditOriginalUrl长度不合法", groups = {ValidatorUpdate.class})
    private String creditOriginalUrl;

    /**
     * 营业执照副本ULR
     */
    @Length(max = 200, message = "参数creditCopyUrl长度不合法", groups = {ValidatorUpdate.class})
    private String creditCopyUrl;

    /**
     * 企业法人姓名
     */
    @Length(max = 20, message = "参数legalPerson长度不合法", groups = {ValidatorUpdate.class})
    private String legalPerson;

    /**
     * 企业法人手机号
     */
    @Length(max = 20, message = "参数legalPhone长度不合法", groups = {ValidatorUpdate.class})
    private String legalPhone;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
