package com.esv.freight.app.module.grabbing.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description: 抢单列表itemVO
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.grabbing.vo.GrabListItemVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/24 16:00
 * @version:1.0
 */
@Data
public class GrabListItemVO {

    /**
     * 主键
     */
    private Long id;
    /**
     * 订单ID
     */
    private Long orderId;
    /**
     * 订单号
     * D+"8位日期“+”6位序号“
     */
    private String orderNo;

    /**
     * 车辆类型（主）
     */
    private Integer vehicleTypeMain;

    /**
     * 车辆类型（子）
     */
    private Integer vehicleTypeSub;

    /**
     * 发布订单量
     */
    private BigDecimal publishGoodsAmount;

    /**
     * 需求车辆数
     */
    private Integer requiredVehicleCount;

    /**
     * 当前抢单车辆数
     */
    private Integer currentVehicleCount;

    /**
     * 当前抢单订单量
     */
    private BigDecimal currentGoodsAmount;

    /**
     * 运费单价（支出）
     */
    private BigDecimal freightUnitPriceOutput;

    /**
     * 是否允许议价，0-否，1-是
     */
    private Boolean bargainAllowed;

    /**
     * 是否签署电子合同，0-否，1-是
     */
    private Boolean contractSigned;

    /**
     * 发货地址 省份
     */
    private String deliveryProvinceCode;

    /**
     * 发货地址 城市
     */
    private String deliveryCityCode;

    /**
     * 发货地址 区县
     */
    private String deliveryDistrictCode;

    /**
     * 发货地址 详细地址
     */
    private String deliveryDetailAddress;

    /**
     * 交货地址 省份
     */
    private String receiveProvinceCode;

    /**
     * 交货地址 城市
     */
    private String receiveCityCode;

    /**
     * 交货地址 区县
     */
    private String receiveDistrictCode;

    /**
     * 交货地址 详细地址
     */
    private String receiveDetailAddress;

    /**
     * 货物名称编码
     */
    private Integer goodsNameCode;

    /**
     * 货物名称
     */
    private String goodsName;

    /**
     * 货物单位
     */
    private Integer goodsUnit;

    /**
     * 发货策略
     */
    private Integer deliveryStrategy;

    /**
     * 要求发货时间
     */
    private Long requiredDeliveryTime;

    /**
     * 要求交货时间
     */
    private Long requiredReceiveTime;

    /**
     * 抢单创建时间
     */
    private Long createTime;

    /**
     * 议价范围百分比
     */
    private Integer bargainRange;
}
