package com.esv.freight.app.module.bill.form;

import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.bill.form.BillQueryForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/02 17:25
 * @version:1.0
 */
@Data
public class BillQueryForm {

    /**
     *
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorDetail.class})
    private Long id;

    /**
     * 账号ID
     */
    @NotNull(message = "参数userId不能为空", groups = {ValidatorList.class})
    private Long userId;

    /**
     * 当前页数
     */
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Long pageNum;

    /**
     * 每页显示记录数
     */
    @Range(min = 1, max = 1000, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Long pageSize;
}
