package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.feign.TmsGrabInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/29 10:00
 * @version:1.0
 */
@FeignClient(value = "freight-tms-service")
public interface TmsGrabInterface {

    /**
     * 查询抢单信息列表
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/order/grabbing/list")
    JSONObject getOrderGrabbingList(JSONObject bodyJson);

    /**
     * 司机抢单
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/order/grabbing/grab")
    JSONObject grabOrder(JSONObject bodyJson);

    /**
     * 司机抢单
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/order/grabbing/grab/prepare")
    JSONObject grabOrderPrepare(JSONObject bodyJson);
}
