package com.esv.freight.app.config;

import com.esv.freight.app.common.component.TokenComponent;
import com.esv.freight.app.common.util.ReqUtils;
import com.esv.freight.app.common.util.SecurityUtils;
import com.esv.freight.app.module.account.CustomToken;
import com.esv.freight.app.module.account.pojo.TokenInfoPojo;
import com.esv.gateway.common.GatewayHeaders;
import feign.RequestInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

import java.lang.reflect.Field;

/**
 * @description: Feign接口配置
 * @project: Spring-Cloud-Single-Template
 * @name: com.esv.freight.config.FeignConfigure
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/09 9:57
 * @version:1.0
 */
@EnableFeignClients(basePackages = "com.esv.freight.app.feign")
@Configuration
@Slf4j
public class FeignConfigure {

    @Value("${spring.application.name}")
    private String applicationName;

    @Autowired
    private TokenComponent tokenComponent;

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    public RequestInterceptor requestInterceptor() {
        RequestInterceptor requestInterceptor = ((requestTemplate -> {
            requestTemplate.header("trace_id", MDC.get("traceId"));
            requestTemplate.header("application_name", applicationName);
            requestTemplate.header("Source-Type", "4");
            requestTemplate.header("esv_data_perm", "0");
            requestTemplate.header("esv_system", "app");
            requestTemplate.header("esv_department", "5");
            requestTemplate.header("esv_department_children", "5,6,7");
            requestTemplate.header("esv_tenant", ReqUtils.getRequestHeader("tenantId"));

            TokenInfoPojo tokenInfoPojo = tokenComponent.getTokenInfo();
            if (tokenInfoPojo != null) {
                requestTemplate.header("esv_user", String.valueOf(tokenInfoPojo.getAccountId()));
                requestTemplate.header("esv_account", tokenInfoPojo.getAccount());
            }
        }));
        return requestInterceptor;
    }
}
