package com.esv.freight.app.module.map.form;

import com.esv.freight.app.common.util.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.map.form.DriverTrackForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/28 09:15
 * @version:1.0
 */
@Data
public class DriverTrackForm implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "参数时间不能为空")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT0)
    private Long time;

    @NotNull(message = "参数司机ID不能为空")
    private Long driverId;

    @NotNull(message = "参数经度不能为空")
    private BigDecimal lng;

    @NotNull(message = "参数纬度不能为空")
    private BigDecimal lat;
}
