package com.esv.freight.app.module.order.vo;

import lombok.Data;
import java.math.BigDecimal;

/**
 * @description: 订单详情VO
 * @project: Freight
 * @name: com.esv.freight.app.module.order.vo.OrderDetailVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/22 10:00
 * @version:1.0
 */
@Data
public class OrderDetailVO {

    /**
     * 订单id
     */
    private Long id;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 订单状态.
     */
    private Integer orderState;

    /**
     * 审核状态
     */
    private Integer auditState;

    /**
     * 业务类型
     */
    private Integer businessType;

    /**
     * 货物类型
     */
    private Integer goodsType;

    /**
     * 货物名称编码
     */
    private Integer goodsNameCode;

    /**
     * 货物明细
     */
    private String goodsDetail;

    /**
     * 货物订单量
     */
    private BigDecimal goodsTotalAmount;
    /**
     * 货物单位
     */
    private Integer goodsUnit;

    /**
     * 货物单价
     */
    private BigDecimal goodsUnitPrice;

    /**
     * 运费单价（收入）
     */
    private BigDecimal freightUnitPriceInput;

    /**
     * 发货地址ID
     */
    private Long deliveryAddressId;

    /**
     * 收货地址ID
     */
    private Long receiveAddressId;
    /**
     * 要求发货时间
     */
    private Long requiredDeliveryTime;
    /**
     * 要求交货时间
     */
    private Long requiredReceiveTime;
    /**
     * 车辆类型，主类型
     */
    private Integer vehicleTypeMain;
    /**
     * 车辆类型，子类型
     */
    private Integer vehicleTypeSub;
    /**
     * 车长
     */
    private BigDecimal vehicleLength;
    /**
     * 备注
     */
    private String remark;
}
