package com.esv.freight.app.module.grabbing.form;

import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.grabbing.form.OrderGrabbingQueryForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/4/24 15:00
 * @version:1.0
 */
@Data
public class OrderGrabbingQueryForm {

    /**
     * 司机ID
     */
    @NotNull(message = "参数司机ID不能为空", groups = {ValidatorList.class})
    private Long driverId;

    /**
     * 抢单信息ID
     */
    @NotNull(message = "参数抢单信息ID不能为空", groups = {ValidatorDetail.class})
    private Long orderGrabbingId;
    /**
     * 订单ID
     */
    @NotNull(message = "参数订单ID不能为空", groups = {ValidatorUpdate.class})
    private Long orderNo;
    /**
     * 车辆类型，主类型
     */
    private Integer vehicleTypeMain;
    /**
     * 车辆类型，子类型
     */
    private Integer vehicleTypeSub;
    /**
     * 发货地址 省份
     */
    @Length(max = 6, message = "参数发货地址 省份长度不合法", groups = {ValidatorList.class})
    private String deliveryProvinceCode;
    /**
     * 发货地址 城市
     */
    @Length(max = 6, message = "参数发货地址 城市长度不合法", groups = {ValidatorList.class})
    private String deliveryCityCode;
    /**
     * 交货地址 省份
     */
    @Length(max = 6, message = "参数交货地址 省份长度不合法", groups = {ValidatorList.class})
    private String receiveProvinceCode;
    /**
     * 交货地址 城市
     */
    @Length(max = 6, message = "参数交货地址 城市长度不合法", groups = {ValidatorList.class})
    private String receiveCityCode;

    /**
     * 抢单状态
     */
    private Integer grabbingOrderState;

    /**
     * 页码
     **/
    @Range(min = 1, max = 1000, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Integer pageNum;

    /**
     * 每页记录条数
     **/
    @Range(min = 1, max = 1000, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}