package com.esv.freight.app.common.filter;

import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.util.AESSecretUtils;
import com.esv.freight.app.common.util.SecurityUtils;
import com.esv.freight.app.common.wrapper.RestRequestWrapper;
import com.esv.freight.app.module.account.CustomToken;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

/**
 * @description: 权限过滤器
 * @project: app-service
 * @name: com.esv.freight.app.common.filter.AuthFilter
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/04/23 15:02
 * @version:1.0
 */
@Slf4j
@RefreshScope
public class AuthFilter implements Filter {

    @Value("${aes.sha1prng.key:freight-app-service-001}")
    private String AES_KEY;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        /************************ Token加解密示例 ************************/
//        log.info(AES_KEY);
//        String tokenTest = "1,13912345678,sn001";
//        String accessTokenTest = AESSecretUtils.encryptToStr(tokenTest, AES_KEY);
//        log.info(tokenTest);
//        log.info(accessTokenTest);
//        log.info(AESSecretUtils.decryptToStr(accessTokenTest, AES_KEY));
        /************************ Token加解密示例 ************************/

        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;

        /**
         * APP请求头示例
         *
         *Map<String,String> map = new HashMap<>();
         *         map.put("requestSource", "2"); // 访问来源
         *         map.put("Union-Authorization", AppConfig.getInstance().getToken()); // token
         *         map.put("osType", osType); // 客户端操作系统名称
         *         map.put("osVer", osVer); // 客户端操作系统版本
         *         map.put("mobileId", mobileId); // 手机唯一标识
         *         map.put("cVer", cVer); // 客户端版本
         */

        // 请求来源：1-浏览器端、2-Android端、3-iOS端、4-后台服务端
        String requestSource = request.getHeader("requestSource");
        if(!"2".equals(requestSource) && !"3".equals(requestSource)) { // 如果不是android或IOS端的请求直接返回
            this.errorResponse(EResponse.error(ECode.ACCESS_DENIED), response);
            return;
        }

        String cVer = request.getHeader("cVer");
        // TODO 终端程序的版本号，以后当程序升级时可以通过版本检测，过低的版本的请求可能需要返回“您的版本过低，请更新应用！”

        String mobileId = request.getHeader("mobileId");
        // TODO 设备标识，用于日后消息推送

        String token = request.getHeader("Union-Authorization");
        log.info(SecurityUtils.desDecode(AES_KEY, token));
        CustomToken customToken = CheckCustomToken.getCustomToken(SecurityUtils.desDecode(AES_KEY, token));

        // 校验token
        RestRequestWrapper requestWrapper = new RestRequestWrapper((HttpServletRequest)servletRequest);
        String url = requestWrapper.getRequestURI();
        CheckCustomToken.check(customToken, url);
        request.setAttribute("tokenInfo", customToken);
        filterChain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void destroy() {

    }

    private void errorResponse(EResponse eResponse, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        try {
            osw = new OutputStreamWriter(response.getOutputStream(), "UTF-8");
            writer = new PrintWriter(osw, true);
            writer.write(eResponse.toString());
            writer.flush();
            osw.close();
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        } finally {
            if (null != writer) {
                writer.close();
            }
            if (null != osw) {
                try {
                    osw.close();
                } catch (IOException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }
}
