package com.esv.freight.app.module.customersupport.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.feign.CustomerSupportInterface;
import com.esv.freight.app.module.customersupport.vo.CustomerSupportVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description:
 * @project: app-service
 * @name: com.esv.freight.app.module.customerservice.controller.OwnerCustomerServiceController
 * @author: 刘胜
 * @email: <liusheng@esvtek.com>
 * @createTime: 2020/8/12 13:31
 * @version: 1.0
 */
@RestController
@RequestMapping("/goodsowner")
@Slf4j
@Validated
public class OwnerCustomerSupportController {

    private CustomerSupportInterface customerSupportInterface;

    @Autowired
    public OwnerCustomerSupportController(CustomerSupportInterface customerSupportInterface) {
        this.customerSupportInterface = customerSupportInterface;
    }

    /**
     * description 获取货主客服电话
     * param []
     * return com.esv.freight.app.common.response.EResponse
     * author 刘胜
     * createTime 2020/8/12 14:35
     **/
    @PostMapping("/customersupport")
    public EResponse ownerCustomer(){
        JSONObject result = customerSupportInterface.ownerCustomer();

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }
        CustomerSupportVO customerSupportVO = new CustomerSupportVO();
        JSONObject data = result.getJSONObject("data");
        customerSupportVO.setPhone(data.getString("phone"));
        return EResponse.ok(customerSupportVO);

    }
}
