package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.feign.DeliveryAddressInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/22 16:00
 * @version:1.0
 */
@FeignClient(value = "freight-customer-service")
public interface DeliveryAddressInterface {

    /**
     * 获取发货地址列表
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/delivery/address/all")
    JSONObject all(JSONObject bodyJson);

    /**
     * 删除发货地址
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/delivery/address/delete")
    JSONObject delete(JSONObject bodyJson);

    /**
     * 编辑发货地址
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/delivery/address/edit")
    JSONObject edit(JSONObject bodyJson);

    /**
     * 添加发货地址
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/delivery/address/add")
    JSONObject add(JSONObject bodyJson);

    /**
     * 发货地址详情
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/delivery/address/detail")
    JSONObject detail(JSONObject bodyJson);
}
