package com.esv.freight.app.module.bill.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.bill.vo.BillDetailVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/03 14:05
 * @version:1.0
 */
@Data
public class BillDetailVO {

    /**
     * 主键
     */
    private Long id;

    /**
     * 对账单号
     */
    private String billNo;

    /**
     * 对账开始时间
     */
    private Date billTimeBucketStart;

    /**
     * 账单结束时间
     */
    private Date billTimeBucketEnd;

    /**
     * 运费
     */
    private BigDecimal freightPrice = BigDecimal.ZERO;

    /**
     * 亏吨
     */
    private BigDecimal less = BigDecimal.ZERO;

    /**
     * 涨吨
     */
    private BigDecimal more = BigDecimal.ZERO;

    /**
     * 信息费
     */
    private BigDecimal info = BigDecimal.ZERO;

    /**
     * 内保费
     */
    private BigDecimal inprotect = BigDecimal.ZERO;

    /**
     * 抹零
     */
    private BigDecimal smallChange = BigDecimal.ZERO;

    /**
     * 罚款
     */
    private BigDecimal punish = BigDecimal.ZERO;

    /**
     * 装卸费
     */
    private BigDecimal handling = BigDecimal.ZERO;

    /**
     * 奖金
     */
    private BigDecimal bonus = BigDecimal.ZERO;

    /**
     * 补贴费
     */
    private BigDecimal subsidy = BigDecimal.ZERO;

    /**
     * 总计费用
     */
    private BigDecimal totalMoney = BigDecimal.ZERO;

    /**
     * 应收对账状态:1-核实中;2-已对账;3-已开票;4-已回款
     * 应付账单状态:1-核实中;2-已对账;3-已支付;4-已开票;5-支付失败
     */
    private Integer billState;

    /**
     * 回款时间
     */
    private Date topUrgent;

    /**
     * 创建时间
     */
    private Date createTime;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
