package com.esv.freight.app.module.account.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.util.ReqUtils;
import com.esv.freight.app.feign.GoodsOwnerInterface;
import com.esv.freight.app.feign.NoticeInterface;
import com.esv.freight.app.module.account.form.LoginForm;
import com.esv.freight.app.module.account.form.ModifyPasswordForm;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 密码Controller
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.account.controller.OwnerPasswordController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 10:00
 * @version:1.0
 */
@RestController
@RequestMapping("/ownerBackend/password")
@Slf4j
@Validated
public class OwnerPasswordController {

    private NoticeInterface noticeInterface;
    private AppLoginService appLoginService;
    private GoodsOwnerInterface goodsOwnerInterface;

    @Autowired
    public OwnerPasswordController(GoodsOwnerInterface goodsOwnerInterface, NoticeInterface noticeInterface, AppLoginService appLoginService) {
        this.noticeInterface = noticeInterface;
        this.appLoginService = appLoginService;
        this.goodsOwnerInterface = goodsOwnerInterface;
    }

    /**
     * description 重置密码
     * param [AccountRegisterForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/13 10:00
     **/
    @PostMapping("/reset")
    public EResponse reset(@RequestBody(required=false) @Validated(ValidatorInsert.class) LoginForm loginForm) {

        // 调用查询帐号详情接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("account", loginForm.getPhone());
        log.info(reqJson.toJSONString());
        JSONObject result = goodsOwnerInterface.getAccountDetail(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") == 1002) {
            return EResponse.error(1002, "手机号未注册");
        }

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        Long id = result.getJSONObject("data").getLong("id");

        // 调用通知服务验证短信接口
        reqJson.clear();
        reqJson.put("phone", loginForm.getPhone());
        reqJson.put("type", "reset_pwd");
        reqJson.put("captcha", loginForm.getSmsCode());
        log.info(reqJson.toJSONString());
        result = noticeInterface.checkSmsCaptcha(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        // 调用编辑帐号信息接口
        reqJson.clear();
        reqJson.put("id", id);
        reqJson.put("password", loginForm.getPwd());
        reqJson.put("ownerType", "1"); //修改密码，此处传1或2都可
        log.info(reqJson.toJSONString());
        result = goodsOwnerInterface.updateAccountInfo(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }

    /**
     * description 修改密码
     * param [AccountRegisterForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/13 10:00
     **/
    @PostMapping("/edit")
    public EResponse edit(@RequestBody(required=false) @Validated(ValidatorInsert.class) ModifyPasswordForm modifyPasswordFrom) {

        appLoginService.checkAccessToken();

        String phone = ReqUtils.getTokenInfo().getAccount();

        // 调用帐号密码校验接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("account", phone);
        reqJson.put("password", modifyPasswordFrom.getOldPwd());
        log.info(reqJson.toJSONString());
        JSONObject result = goodsOwnerInterface.checkAccountPwd(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") == 1002) {
            return EResponse.error(1001, "原密码错误");
        }

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        Long id = result.getJSONObject("data").getLong("id");

        // 调用编辑帐号信息接口
        reqJson.clear();
        reqJson.put("id", id);
        reqJson.put("password", modifyPasswordFrom.getNewPwd());
        reqJson.put("ownerType", "1"); //修改密码，此处传1或2都可
        log.info(reqJson.toJSONString());
        result = goodsOwnerInterface.updateAccountInfo(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }
}
