package com.esv.freight.app.module.account.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.app.common.exception.EException;
import com.esv.freight.app.module.account.dao.AppLoginDao;
import com.esv.freight.app.module.account.entity.AppLoginEntity;
import com.esv.freight.app.module.account.form.RefreshTokenForm;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.account.vo.LoginVO;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

@Service("appLoginService")
public class AppLoginImpl extends ServiceImpl<AppLoginDao, AppLoginEntity> implements AppLoginService {

    private void createToken(AppLoginEntity entity) {
        if(entity == null) {
            return;
        }

        entity.setAccessToken(UUID.randomUUID().toString().replaceAll("-", ""));
        entity.setRefreshToken(UUID.randomUUID().toString().replaceAll("-", ""));
    }

    @Override
    public LoginVO login(String phone) {

        AppLoginEntity appLoginEntity = this.getAccountByPhone(phone);
        if(null == appLoginEntity) {
            return addLogin(phone);
        }

        createToken(appLoginEntity);
        appLoginEntity.setLoginStatus("1");
        appLoginEntity.setLoginTime(new Date());
        appLoginEntity.setRefreshTime(new Date());
        appLoginEntity.setAccessTokenValidTime(getFuture(1));
        appLoginEntity.setRefreshTokenValidTime(getFuture(30));
        this.baseMapper.updateById(appLoginEntity);

        //数据转换
        LoginVO loginByPwdVO = new LoginVO();
        loginByPwdVO.setAccessToken(appLoginEntity.getAccessToken());
        loginByPwdVO.setRefreshToken(appLoginEntity.getRefreshToken());
        return loginByPwdVO;
    }

    private LoginVO addLogin(String phone) {
        AppLoginEntity appLoginEntity = new AppLoginEntity();
        appLoginEntity.setPhone(phone);
        createToken(appLoginEntity);
        appLoginEntity.setLoginStatus("1");
        appLoginEntity.setLoginTime(new Date());
        appLoginEntity.setRefreshTime(new Date());
        appLoginEntity.setAccessTokenValidTime(getFuture(1));
        appLoginEntity.setRefreshTokenValidTime(getFuture(30));
        this.baseMapper.insert(appLoginEntity);

        //数据转换
        LoginVO loginByPwdVO = new LoginVO();
        loginByPwdVO.setAccessToken(appLoginEntity.getAccessToken());
        loginByPwdVO.setRefreshToken(appLoginEntity.getRefreshToken());
        return loginByPwdVO;
    }

    @Override
    public void logout(String accessToken) {
        AppLoginEntity entity = this.getAccountByAccessToken(accessToken);
        if(entity == null) {
            throw new EException(602, "Token已过期,请重新登录");
        }

        entity.setAccessToken("");
        entity.setRefreshToken("");
        entity.setLoginStatus("2");
        entity.setLogoutTime(new Date());
        this.baseMapper.updateById(entity);
    }

    @Override
    public LoginVO refreshToken(String accessToken, RefreshTokenForm refreshTokenForm) {
        AppLoginEntity entity = this.getAccountByAccessToken(accessToken);
        if(entity == null) {
            throw new EException(602, "Token已过期,请重新登录");
        }

        if(isInvalidRefreshToken(refreshTokenForm.getRefreshToken())) {
            throw new EException(602, "Token已过期,请重新登录");
        }

        createToken(entity);
        entity.setRefreshTime(new Date());
        entity.setLoginStatus("1");
        entity.setAccessTokenValidTime(getFuture(1));
        entity.setRefreshTokenValidTime(getFuture(30));
        this.baseMapper.updateById(entity);

        //数据转换
        LoginVO loginByPwdVO = new LoginVO();
        loginByPwdVO.setAccessToken(entity.getAccessToken());
        loginByPwdVO.setRefreshToken(entity.getRefreshToken());
        return loginByPwdVO;
    }

    @Override
    public boolean isInvalidAccessToken(String accessToken) {

        AppLoginEntity entity = this.getAccountByAccessToken(accessToken);
        if(entity == null) {
            throw new EException(602, "Token已过期,请重新登录");
        }

        Date current = new Date();
        Date accessDate = entity.getAccessTokenValidTime();

        if(current.after(accessDate)) {
            return true;
        }

        return false;
    }

    @Override
    public boolean isInvalidRefreshToken(String refreshToken) {
        AppLoginEntity entity = this.getAccountByRefreshToken(refreshToken);
        if(entity == null) {
            throw new EException(602, "Token已过期,请重新登录");
        }

        Date current = new Date();
        Date refreshDate = entity.getRefreshTokenValidTime();

        if(current.after(refreshDate)) {
            return true;
        }

        return false;
    }

    @Override
    public String getPhoneByAccessToken(String accessToken) {
        AppLoginEntity entity = this.getAccountByAccessToken(accessToken);
        if(entity == null) {
            throw new EException(602, "Token已过期,请重新登录");
        }

        return entity.getPhone();
    }

    private AppLoginEntity getAccountByPhone(String phone) {
        QueryWrapper<AppLoginEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("phone", phone);
        return this.baseMapper.selectOne(queryWrapper);
    }

    private AppLoginEntity getAccountByAccessToken(String accessToken) {
        QueryWrapper<AppLoginEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("access_token", accessToken);
        return this.baseMapper.selectOne(queryWrapper);
    }

    private AppLoginEntity getAccountByRefreshToken(String refreshToken) {
        QueryWrapper<AppLoginEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select().eq("refresh_token", refreshToken);
        return this.baseMapper.selectOne(queryWrapper);
    }

    /**
     * 返回未来天数
     * @param days
     * @return
     */
    public Date getFuture(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(Calendar.DATE, calendar.get(Calendar.DATE) + days);
        return calendar.getTime();
    }
}
