package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: Freight
 * @name: com.esv.freight.app.feign.TmsInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/21 10:00
 * @version:1.0
 */
@FeignClient(value = "freight-tms-service")
public interface TmsInterface {

    /**
     * 发布订单
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/order/add/owner")
    JSONObject addOrderOwner(JSONObject bodyJson);

    /**
     * 获取订单列表
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/order/list")
    JSONObject listOrders(JSONObject bodyJson);

    /**
     * 取消订单
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/order/cancel")
    JSONObject cancelOrder(JSONObject bodyJson);

    /**
     * 编辑订单
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/order/edit")
    JSONObject editOrder(JSONObject bodyJson);

    /**
     * 查询订单详情
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/order/detail")
    JSONObject getOrderDetail(JSONObject bodyJson);
}
