package com.esv.freight.app.module.message.controller;

import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.validator.groups.ValidatorDelete;
import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import com.esv.freight.app.common.vo.PageResultVO;
import com.esv.freight.app.module.message.form.MessageForm;
import com.esv.freight.app.module.message.service.BusinessMessageService;
import com.esv.freight.app.module.message.validator.groups.ValidatorDeleteByType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 司机消息Controller
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.message.controller.MessageController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/10 09:40
 * @version:1.0
 */
@RestController
@RequestMapping("/driverBackend/message")
@Slf4j
@Validated
public class DriverMessageController {

    private BusinessMessageService businessMessageService;

    @Autowired
    public DriverMessageController(BusinessMessageService businessMessageService) {
        this.businessMessageService = businessMessageService;
    }

    @PostMapping("/type")
    public EResponse getMessageType(@RequestHeader @RequestBody(required=false) @Validated(ValidatorUpdate.class) MessageForm messageForm) {
        return EResponse.ok(businessMessageService.getMessageType(messageForm));
    }

    @PostMapping("/list")
    public EResponse<PageResultVO> getMessageList(@RequestHeader @RequestBody(required=false) @Validated(ValidatorList.class) MessageForm messageForm) {
        return EResponse.ok(businessMessageService.getMessageList(messageForm));
    }

    @PostMapping("/detail")
    public EResponse getMessageDetail(@RequestHeader @RequestBody(required=false) @Validated(ValidatorDetail.class) MessageForm messageForm) {
        return EResponse.ok(businessMessageService.getMessageDetail(messageForm));
    }

    @PostMapping("/deleteById")
    public EResponse deleteById(@RequestHeader @RequestBody(required=false) @Validated(ValidatorDelete.class) MessageForm messageForm) {
        businessMessageService.deleteMessageById(messageForm);
        return EResponse.ok();
    }

    @PostMapping("/deleteByType")
    public EResponse deleteByType(@RequestHeader @RequestBody(required=false) @Validated(ValidatorDeleteByType.class) MessageForm messageForm) {
        businessMessageService.deleteMessageByType(messageForm);
        return EResponse.ok();
    }

    @PostMapping("/setAllRead")
    public EResponse setAllRead(@RequestHeader @RequestBody(required=false) @Validated(ValidatorUpdate.class) MessageForm messageForm) {
        businessMessageService.setAllRead(messageForm);
        return EResponse.ok();
    }
}
