package com.esv.freight.app.module.message.form;

import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description: 推送消息
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.message.form.PushMessageForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/10 10:15
 * @version:1.0
 */
@Data
public class PushMessageForm {

    /**
     * 帐号ID
     **/
    @NotNull(message = "参数accountId不能为空", groups = {ValidatorInsert.class})
    private Long accountId;

    /**
     * APP类型：1-司机、2-货主
     */
    @NotNull(message = "参数appType不能为空", groups = {ValidatorInsert.class})
    @Range(min = 1, max = 2, message = "无效的appType", groups = {ValidatorInsert.class})
    private Integer appType;

    /**
     * 消息类型，具体请参考文档
     */
    @NotNull(message = "参数messageType不能为空", groups = {ValidatorInsert.class})
    private Integer messageType;

    /**
     * 业务数据，根据业务自定义JSON
     */
    private String messageData;
}
