package com.esv.freight.app.module.account.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.app.module.account.entity.AppLoginEntity;
import com.esv.freight.app.module.account.form.RefreshTokenForm;
import com.esv.freight.app.module.account.vo.LoginVO;

/**
 * APP用户登录信息表
 *
 * @author 张志臣
 * @email zhangzhichen@esvtek.com
 * @date 2020-04-15 10:00
 */
public interface AppLoginService extends IService<AppLoginEntity> {

    LoginVO login(String phone);

    void logout(String accessToken);

    LoginVO refreshToken(String accessToken, RefreshTokenForm refreshTokenForm);

    boolean isInvalidAccessToken(String accessToken);

    boolean isInvalidRefreshToken(String refreshToken);
}