package com.esv.freight.app.module.message.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @description: APP帐号设备信息表
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.message.entity.AccountDeviceInfoEntity
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/09 17:00
 * @version:1.0
 */
@Data
@TableName("account_device_info")
public class AccountDeviceInfoEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @TableId
    private Long id;

    /**
     * 租户ID
     */
    private Long tenantId;

    /**
     * 部门ID
     */
    private Long departmentId;

    /**
     * 帐号
     */
    private String account;

    /**
     * 帐号ID
     */
    private Long accountId;

    /**
     * 帐号类型：1-司机、2-货主
     */
    private Integer accountType;

    /**
     * 设备类型：2-android、3-ios
     */
    private Integer deviceType;

    /**
     * 设备序列号
     */
    private String deviceSn;

    /**
     * 修改时间
     */
    private Date updateTime;
}
