package com.esv.freight.app.module.account.form;

import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import com.esv.freight.app.module.account.validator.groups.ValidatorLoginBySms;
import com.esv.freight.app.module.account.validator.groups.ValidatorResetPwd;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description: 刷新token验证类
 * @project: freight-app-service
 * @name: com.esv.freight.module.ownerBackend.account.form.RefreshTokenForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/18 09:00
 * @version:1.0
 */
@Data
public class RefreshTokenForm {

    /**
     * 刷新token
     */
    @NotBlank(message = "参数refreshToken不能为空", groups = {ValidatorUpdate.class})
    private String refreshToken;

    /**
     * 推送设备ID
     */
    @NotBlank(message = "参数pushId不能为空", groups = {ValidatorUpdate.class})
    private String pushId;
}
